#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>

#define BR_VOZILA_PO_SMERU_A 7
#define BR_VOZILA_PO_SMERU_B 3

#define AUTO 0
#define AUTOBUS 1
#define KAMION 2

#define NONE -1
#define SMER_A 0
#define SMER_B 1

#define VREME_DOLASKA_MAX_SEC  10
#define VREME_DOLASKA_MIN_SEC  1

#define VREME_PROLASKA_MAX_SEC 10
#define VREME_PROLASKA_MIN_SEC 1

pthread_mutex_t mutex;
pthread_cond_t cond;

int trenutni_smer = NONE;

int br_vozila[3] = {0, 0, 0}; // AUTO, AUTOBUS, KAMION

char* dajTipVozila(int tip) {
    if(tip == AUTO) return "AUTO";
    else if(tip == AUTOBUS) return "AUTOBUS";
    else if(tip == KAMION) return "KAMION";
    return "NONE";
}

char* dajSmer(int smer) {
    if(smer == SMER_A) return "A";
    else if(smer == SMER_B) return "B";
    return "NONE";
}

void* vozi(void* arg) {
    int smer = (int) arg;
    int tip = rand() % 3;

    int vreme_dolaska = rand() % (VREME_DOLASKA_MAX_SEC + 1) + VREME_DOLASKA_MIN_SEC;
    sleep(vreme_dolaska);
    printf("%s dolazi na nadvoznjak u smeru %s\n", dajTipVozila(tip), dajSmer(smer));

    pthread_mutex_lock(&mutex);
    
    while((trenutni_smer != smer && trenutni_smer != NONE) ||
          (tip == AUTO && br_vozila[KAMION] > 0) ||
          (tip == AUTOBUS && (br_vozila[AUTOBUS] > 0 || br_vozila[KAMION] > 0)) ||
          (tip == KAMION && (br_vozila[AUTO] > 0 || br_vozila[AUTOBUS] > 0 || br_vozila[KAMION] > 0))) {
        pthread_cond_wait(&cond, &mutex);
    }

    trenutni_smer = smer;
    br_vozila[tip]++;

    pthread_mutex_unlock(&mutex);

    int vreme_prolaska = rand() % (VREME_PROLASKA_MAX_SEC + 1) + VREME_PROLASKA_MIN_SEC;
    printf("%s prelazi nadvoznjak u smeru %s, vreme: %d\n", dajTipVozila(tip), dajSmer(smer), vreme_prolaska);
    sleep(vreme_prolaska);

    pthread_mutex_lock(&mutex);

    br_vozila[tip]--;
    if(br_vozila[AUTO] == 0 && br_vozila[AUTOBUS] == 0 && br_vozila[KAMION] == 0) {
        trenutni_smer = NONE;
    }
    pthread_cond_broadcast(&cond);
    printf("%s presao nadvoznjak u smeru %s\n", dajTipVozila(tip), dajSmer(smer));

    pthread_mutex_unlock(&mutex);

    return NULL;
}

int main() {
    srand(4);
    // srand(time(NULL));

    pthread_t vozila[BR_VOZILA_PO_SMERU_A + BR_VOZILA_PO_SMERU_B];

    for(int i = 0; i < BR_VOZILA_PO_SMERU_A + BR_VOZILA_PO_SMERU_B; i++) {
        int smer = SMER_B;
        if(i < BR_VOZILA_PO_SMERU_A) {
            smer = SMER_A;
        }
        pthread_create(&vozila[i], NULL, (void*) vozi, (void*) smer);
    }

    pthread_exit(NULL);
    return 0;
}